PROCEDURE PlaceTrussTagTest;

CONST
	{$INCLUDE VW_Spotlight\Includes\CableTools\PIO const lib.px}
	{$INCLUDE VW_Spotlight\Includes\CableTools\GLOBAL_CONST 2023.px}
	{Alignment constants}
	kRight                = 1;
	kBottom               = 2;
	kLeft                 = 3;
	kColumn               = 4;
	kResize               = 0;
	kShift                = 1;

	{ dialog resource ID }
	kTextStrTableID       = 3000;

	{ default and cancel button IDs}
	kOK                   = 1;
	kCancel               = 2;

	{ control IDs}
	kTagMenuLbl           = 4;
	kTagSymMenu           = 5;
	
	
	kPIOName = 'VLM Truss Tag';


TYPE  	 	
 	 LabelThing = STRUCTURE
 		Name : STRING;
 		List : INTEGER; {0 = Document symbol list, 1 = User label list, 2 = AP Label List}
 	END;

VAR
	{$INCLUDE VW_Spotlight\Includes\CableTools\GLOBAL_VARS.px}
	ClickObj					:HANDLE;
	DefaultLabel			:STRING;
	GoodObj					:BOOLEAN;
	LabelArray				:ARRAY[1..100] OF HANDLE;
	LabelHdl					:HANDLE;
	LabelListCt				:INTEGER;
	LabelListIDX			:LONGINT;
	LabelName				:STRING;
	LabelOffsetX			:REAL;
	LabelOffsetY			:REAL;
	Missed					:BOOLEAN;
	NewGrpObj				:HANDLE;
	NumLabels				:INTEGER;
	NumObjects				:INTEGER;
	ObjRec					:HANDLE;
	ObjRecNm					:STRING;
	OrigX						:REAL;
	OrigY						:REAL;
	PieceSepChar			:STRING;
	StrHolder				:STRING;
	SubFolderName			:STRING;
	TheTruss					:HANDLE;
	TrussLabelList			:ARRAY[1..50] OF LabelThing;
	TrussLabelCnt			:INTEGER;
	TrussLblListCt			:LONGINT;
	TrussLblListIDX		:LONGINT;
	UserTrussLblListCt	:LONGINT;
	UserTrussLblListIDX	:LONGINT;
	TBBoxX1, TBBoxY1		:REAL;
	TBBoxX2, TBBoxY2		:REAL;
	UseLftCorner			:BOOLEAN;
	X, Y, Z					:REAL;
	X1, Y1, X2, Y2			:REAL;
	
	{Test Variables}
	LblHandle				:HANDLE;
	
	TheItem					:LONGINT;
	dialog         		:LONGINT;
	cnt            		:INTEGER;


{==============================================================}

	{$INCLUDE VW_Spotlight\Includes\CableTools\GLOBAL_PROCS SL.px}

{==============================================================}

	FUNCTION IsTrussTagSym(symName : STRING) : BOOLEAN;
	
	VAR
		objHdl	:HANDLE;
		objType	:LONGINT;
		result	:BOOLEAN;
		recName	:STRING;
		recHdl	:HANDLE;
		numRecs	:INTEGER;
		index		:INTEGER;
		
	BEGIN
		result := FALSE;
		objHdl := GetObject(symName);
		IF ((objHdl <> NIL) & (GetType(objHdl) = 16)) THEN
			BEGIN
				numRecs := NumRecords(objHdl);
				FOR index := 1 TO numRecs DO
					BEGIN
						recHdl := GetRecord(objHdl, index);
						IF GetName(recHdl) = 'Truss Label Record' THEN
							BEGIN
								result := TRUE;
								index := numRecs;
							END;
					END; {FOR index := 1 TO numRecs}
			END; {IF GetType(SymName) = 16}
			
		IsTrussTagSym := result;
		
	END; {FUNCTION IsTrussTagSym}
	
{=================================================================}

	FUNCTION CheckObjCallback(h : HANDLE) : BOOLEAN;
	
	VAR
		paramRec			:HANDLE;
		paramRecName	:STRING;
 
	BEGIN
		IF h <> NIL THEN
			BEGIN
				paramRec := GetParametricRecord(h);
				IF paramRec <> NIL THEN
					BEGIN
						IF (GetName(paramRec) = 'Straight Truss') THEN
							CheckObjCallback := TRUE
						ELSE IF (GetName(paramRec) = 'Curved Truss') THEN
							CheckObjCallback := TRUE
						ELSE IF (GetName(paramRec) = 'Light Position Obj') THEN
							CheckObjCallback := TRUE
						ELSE IF (GetName(paramRec) = 'TrussItem') THEN
							CheckObjCallback := TRUE
						ELSE
							CheckObjCallback := FALSE;
					END
				ELSE IF GetType(h) = 11 THEN
					CheckObjCallback := TRUE
				ELSE
					CheckObjCallback := FALSE;
			END {IF h <> NIL}
		ELSE
			CheckObjCallback := FALSE;

	END; {FUNCTION CheckObjCallback}

{==============================================================}

	PROCEDURE CollectTrussLabels;
	
	VAR
		subFolderName : STRING;
		index : INTEGER;
		index2 : INTEGER;
		resName : STRING;
		apResName : STRING;
		userResName : STRING;
		found : BOOLEAN;
		
	{----------------------------------------------------------------------------------------}	
	
		FUNCTION CollectSyms(theSymDef:HANDLE) : BOOLEAN;
		
		VAR
			recHdl : HANDLE;
			recName : STRING;
			symName : STRING;
			resSymName : STRING;
			I : Integer;
			Found : Boolean;
			
		BEGIN
			IF (theSymDef <> NIL) THEN
				BEGIN   
					IF (GetType(theSymDef) = 16) THEN
						BEGIN
							symName := GetSDName(theSymDef);
							IF (GetRecord(theSymDef,1) <> NIL) THEN
								BEGIN
									IF (GetName(GetRecord(theSymDef,1)) = kTrussLabelRecName) THEN
										BEGIN
											TrussLabelCnt := TrussLabelCnt + 1;
											TrussLabelList[TrussLabelCnt].Name := symName;
											TrussLabelList[TrussLabelCnt].List := 0;
										END; {IF GetName(GetRecord(symDef,1)) = kTrussLabelRecName}
								END; {IF (GetRecord(theSymDef,1)) <> NIL}
						END; {IF ((GetType(theSymDef) = 16) & }
				END; {IF GetType(theSymDef) = 16}
		END; {FUNCTION CollectSyms}
		
	{----------------------------------------------------------------------------------------}	
	
	BEGIN
		SubFolderName := CONCAT(kAPSymbolFolder, SepChar, kAPTrussLabelFolder);
(*
AlrtDialog(concat('First SubFolderName = ', SubFolderName));		TrussLblListIDX := BuildResourceList2(16, -2, SubFolderName, TrussLblListCt, TRUE);
*)
		TrussLblListCt := ResourceListSize(TrussLblListIDX);
	
		SubFolderName := CONCAT(kMasterUserFolder, SepChar, kUserSymFolder, SepChar, kUserTrussLabelFolder);
(*AlrtDialog(concat('User SubFolderName = ', SubFolderName));		UserTrussLblListIDX := BuildResourceList2(16, -2, SubFolderName, UserTrussLblListCt, TRUE);*)
		UserTrussLblListCt := ResourceListSize(TrussLblListIDX);

		TrussLabelCnt := 0;
		ForEachObjectInList(CollectSyms,0,2,FSymDef);
(*AlrtDialog(concat(TrussLabelCnt, ' Label symbols were already in the document'));*)
		{If there are no Labels in the symbol definitions, get the first Label in the XML lists}
		IF TrussLabelCnt = 0 THEN
			BEGIN
				IF UserTrussLblListCt > 0 THEN
					BEGIN
						TrussLabelCnt := 1;
						TrussLabelList[TrussLabelCnt].Name := GetActualNameFromResourceList(UserTrussLblListIDX, 1);
						TrussLabelList[TrussLabelCnt].List := 1;
					END
				ELSE
					BEGIN
						TrussLabelCnt := 1;
						TrussLabelList[TrussLabelCnt].Name := GetActualNameFromResourceList(TrussLblListIDX, 1);
						TrussLabelList[TrussLabelCnt].List := 2;
					END
			END; {IF TrussLabelCnt = 0}

		IF TrussLabelCnt + 1 <= kMaxNumTrussLabels THEN
			BEGIN
				FOR index := 1 TO UserTrussLblListCt DO
					BEGIN
						userResName := GetActualNameFromResourceList(UserTrussLblListIDX,index);
(*AlrtDialog(concat('Testing  "', userResName, '"  from the user folder '));*)
						IF IsTrussTagSym(userResName) THEN
							BEGIN
								found := FALSE;
								FOR index2 := 1 TO TrussLabelCnt DO
									BEGIN
										IF TrussLabelList[index2].Name = userResName THEN
											found := TRUE;
									END; {FOR index2 := 1 TO UserBOLblListCt}
							
							
								IF (NOT found) THEN
									BEGIN
										TrussLabelCnt := TrussLabelCnt + 1;
(*AlrtDialog(concat('"', userResName, '"  was added to the Label List'));*)
										TrussLabelList[TrussLabelCnt].Name := userResName;
										TrussLabelList[TrussLabelCnt].List := 1;
										IF TrussLabelCnt = kMaxNumTrussLabels THEN
											BEGIN
												index := UserTrussLblListCt;
												index2 := TrussLabelCnt;
											END;
									END; {IF (NOT found) }
							END; {IF IsTrussTagSym(userResName) }
					END; {FOR index := 1 TO UserBOLblListCt}
				
				IF (TrussLabelCnt + 1 <= kMaxNumTrussLabels) THEN
					BEGIN
						FOR index := 1 TO TrussLblListCt DO
							BEGIN
								apResName := GetActualNameFromResourceList(TrussLblListIDX, index);
(*AlrtDialog(concat('Testing  "', apResName, '"  from the AP file '));*)
								found := FALSE;
								FOR index2 := 1 TO TrussLabelCnt DO
									BEGIN
										resName := TrussLabelList[index2].Name;
										IF apResName = resName THEN
											BEGIN
												found := TRUE;
												index2 := TrussLabelCnt;
											END;
									END; {FOR index2 := 1 TO TrussLabelCnt}
								IF NOT found THEN
									BEGIN
										TrussLabelCnt := TrussLabelCnt + 1;
(*AlrtDialog(concat('"', apResName, '"  was added to the Label List'));*)
										TrussLabelList[TrussLabelCnt].Name := apResName;
										TrussLabelList[TrussLabelCnt].List := 2;
										IF TrussLabelCnt = kMaxNumTrussLabels THEN
											BEGIN
												index := TrussLblListCt;
												index2 := TrussLabelCnt;
											END;
									END; {IF NOT found}
							END; {FOR index := 1 TO BreakOutLblListCt}
					END; {IF TrussLabelCnt + 1 <= kMaxNumBOLabels}
			END; {IF TrussLabelCnt + 1 <= kMaxNumBOLabels}
		SortArray(TrussLabelList, TrussLabelCnt, 1);
	END; {PROCEDURE CollectTrussLabels}
	
{==============================================================}

	PROCEDURE AssignLabel(*(trussObj : HANDLE)*);
	
	VAR
		footPos			:INTEGER;
		grpObj			:HANDLE;
		notOrtho			:BOOLEAN;
		ok					:BOOLEAN;
		tagHdl			:HANDLE;
		tBoltCnt			:STRING;
		tColor			:STRING;
		tConnType		:STRING;
		tDrawPtr			:BOOLEAN;
		tHeight			:REAL;
		tHtStr			:STRING;
		tLen				:STRING;
		tLenNum			:REAL;
		tName				:STRING;
		tPosition		:STRING;
		tRot				:REAL;
		trX, trY, trZ	:REAL;
		tTrim				:REAL;
		tTrimStr			:STRING;
		tType				:STRING;
		tUID				:STRING;
		tWeight			:STRING;
		x1, y1, x2, y2	:REAL;
	
	BEGIN
		tagHdl := CreateCustomObjectN('VLM Truss Tag', X, Y, 0, False);
		DefaultLabel := 'Name & Trim';	
(*
		NumLabels := NumLabels + 1;
		LabelArray[NumLabels] := tagHdl;
*)
		(*ok := AddAssociation(trussObj, kOnDeleteDelete, tagHdl);*)
		SetRField(tagHdl, kPIOName, 'UseSymbol', DefaultLabel);
(*
		SetRField(tagHdl, kPIOName, 'TrussUID', GetName(trussObj));
		IF PieceSepChar <> '' THEN
			SetRField(tagHdl, kPIOName, 'SepChar', PieceSepChar);
*)
		
		
		ResetObject(tagHdl);
		
	END;
	
{=================================================================}

BEGIN
AlrtDialog('Running New Truss Tags');
	NumLabels := 0;
	GetVersion(Major,Minor,Maintenance,Platform);
	GetUnits(Fraction,Display,Format,UPI,UnitName,SquareName);
	GetOrigin(OrigX, OrigY);
	SetOrigin(0-OrigX, 0-OrigY);
	GetPathSepChar;
	CollectTrussLabels;
	
	TrackObjectN(0,CheckObjCallback, ClickObj, X, Y, Z );
	WHILE ClickObj <> NIL DO
		BEGIN
			IF ClickObj <> NIL THEN
				BEGIN
					GetBBox(ClickObj, X1, Y1, X2, Y2);
					MoveTo(X, Y);
					CreateText('Place Tag Here');
					LblHandle := CreateCustomObjectN('VLM Truss Tag', X, Y, 0, False);
					SetRField(LblHandle, kPIOName, 'UseSymbol', DefaultLabel);
					TrackObjectN(0,CheckObjCallback, ClickObj, X, Y, Z );
				END;
		END; {WHILE ClickObj <> NIL}
		
END;
RUN(PlaceTrussTagTest);
